//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-6: Fluidisation
//Example: 6.1 Page 298
//Title:  Minimum fluidisation velocity
//======================================================

model Ex6_1
extends Modelica.Constants; 

//=============
// Parameter Section
 
parameter Real d(unit="m")=3e-3 " Diameter";
parameter Real v1(unit="Pa s")=3e-3 " Viscosity";
parameter Real p1(unit="kg/m^3")=1100 " Liquid density";
parameter Real p1p(unit="kg/m^3")=4200 " Particle density";
parameter Real emf(unit="")=0.4 " Value of emf";

//=============
// Variable Section

Real Ga " Galileo Number";
Real Remf" Reynolds number for minimum fluidisation";
Real umf(unit="m/s") " Minimum fluidisation velocity";

//=============
// Equation Section

equation

Ga=(d^3)*p1*(p1p-p1)*g_n/(v1^2);
Remf=25.7*(((1+(5.53e-5*Ga))^0.5)-1);
umf=Remf*v1/(p1*d);

end Ex6_1;
//===============
