//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-6: Fluidisation
//Example: 6.4 Page 345
//Title:  Slope of adsorption isotherm
//======================================================

model Ex6_4
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real yo=1.442e-2 " Mole fraction of iso-octane in inlet";
parameter Real G(unit="kmol/ s")=0.679e-6 " Gas flow rate";
parameter Real m(unit="g")=4.66 " Mass of the solids in the bed";
parameter Real t[8](each unit="s")={250,500,750,1000,1250,1500,1750,2000} " Time ";
parameter Real y[8]={0.223,0.601,0.857,1.062,1.207,1.287,1.338,1.373} " Mole fraction in outlet gas";
parameter Real s(unit="1/s")=-0.00167 " Slope from graph";

//=============
// Variable Section

Real lny[8] " Value of y axis in graph";
Real b(unit="kmol/kg") " Slope of isotherm";

//=============
// Equation Section

equation

for i in 1:8 loop
lny[i]= log( 1- (y[i]/(100*yo)));
end for;

s=-G/(m*b*1e-3);

end Ex6_4;
//===============
