//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-6: Fluidisation
//Example: 6.6 Page 350
//Title:  Heat transfer coefficient and volume fraction of bed
//======================================================

model Ex6_6

//=============
// Parameter Section
 
parameter Real d(unit="m")=0.25e-3 " Diameter";
parameter Real e =0.5" Voidage";
parameter Real G(unit="kg/m^2 s")=0.2 " Gas flow rate";
parameter Real Cp(unit="J/kg K")=850 " Specific heat capacity";
parameter Real T(unit="K mm") =6.31 " Temperature difference found from the plot";
parameter Real dT(unit="K")=50 " Temperature difference for rate of evaporation";
parameter Real Lhv(unit="J/kg")=2.6e6 " Latent heat of vapourisation of water";
parameter Real ev(unit="kg/s")=0.1 " Evaporation rate";

//=============
// Variable Section

Real h(unit="W/m^2K")" Heat transfer coefficient";
Real A(unit="m^2") " Area of heat transfer";
Real f " Fraction of bed used";

//=============
// Equation Section

equation

G*Cp*6.3=T*1e-3*(6*(1-e)/d)*h;
h*A*dT=ev*Lhv;
f=A/(ev*6*(1-e)/d);

end Ex6_6;
//===============
