//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-7: Liquid Filtration
//Example: 7.1 Page 394
//Title:  Volume of filtrate
//======================================================
  
model Ex7_1
extends Modelica.Math;

//=============
// Parameter Section

//Leaf Filter
parameter Real A1(unit="m^2")=0.05" Area";
parameter Real Pd(unit="N/m^2")=71.3e3 " Pressure difference";
parameter Real t[2](each unit="s")={300,600} " Time to filter";
parameter Real V[2](each unit="m^3")={2.5e-4,4e-4} " Volume collected";

//Plate and Frame Filter
parameter Real n=12 " No of filters";
parameter Real l(unit="m")=0.3 " Length of the square plate";
parameter Real th(unit="m")=25e-3 " Thickness";
parameter Real t1[2](each unit="s")={180,900}" Time to filter";
parameter Real tw(unit="s")=600" Wash time";
parameter Real Pd1[2](each unit="N/m^2")={400e3,275e3} " Pressure Drop";

//=============
// Variable Section

Real lv " Value of L/V";
Real ruv " Value of ruv";
Real A2(unit="m^2")" Area of filter press";
Real V1(unit="m^3", start=0.018)" Volume during constant rate period ";
Real V2(unit="m^3", start=0.062)" Volume during constant pressure period ";
Real final_rate(unit="m^3/s") " Final rate of filtration";
Real washrate[2](each unit="m^3/s") " Rate of washing";
Real Vwash(unit="m^3") " Wash water amount passed";

//=============
// Equation Section

equation

V[1]^2 + (2*A1*(lv)*V[1])= 2* Pd* A1*A1*t[1]/ruv;
V[2]^2 + (2*A1*(lv)*V[2])= 2* Pd* A1*A1*t[2]/ruv;
A2=n*l*l*2;
(V1^2) + (A2*(lv)*V1)= (Pd1[1]* A2*A2/ruv)*t1[1];
((V2^2)-(V1^2)) + (2*A2*lv*(V2-V1))= (2*Pd1[1]*A2*A2/ruv)*t1[2];
final_rate=Pd1[1]*A2*A2/(ruv*(V2+(A2*lv)));
washrate[1]=0.25*final_rate;
washrate[2]=washrate[1]*Pd1[2]/Pd1[1];
Vwash=tw*washrate[2];

// There is a difference in the value of V2 and consequently washrate because th e quadratic equation given in the book is incorrect.

end Ex7_1;
//===============
