//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-7: Liquid Filtration
//Example: 7.2 Page 398
//Title:  Optimum thickness of the cake
//======================================================
  
model Ex7_2

//=============
// Parameter Section

parameter Real p1(unit="kg/m^3") =3000 " Density of slurry";
parameter Real m(unit="kg") =100 " Mass of slurry";
parameter Real e =0.4 " Voidage";
parameter Real A(unit="m^2")=1e-4 " Area";
parameter Real P(unit="N/m^2")=1000e3 " Pressure";
parameter Real Pd(unit="N/m^2")=165e3 " Pressure Drop";
parameter Real Vt(unit="m^3/s")=2e-8 " Flow of water";
parameter Real v1(unit="Pa s")=1e-3 " Viscosity";
parameter Real l(unit="m")=0.01 " Length";
parameter Real t(unit="s")=900 " Time";

//=============
// Variable Section

Real vw(unit="m^3") " Volume of the whiting";
Real vc(unit="m^3") " Volume of the cake";
Real vlc(unit="m^3") " Volume of liquid in the cake";
Real vf(unit="m^3") " Volume of the filtrate";
Real v " Volume ratio";
Real r(unit="m^(-2)") " Specific resistance of cake";
Real L(unit="m") " Optimum frame length";
Real Lact(unit="m") " Actual frame length";
Real T(unit="m") " Optimum frame thickness";
Real Tact(unit="m") " Actual frame thickness";

//=============
// Equation Section

equation

vw=m/p1;
vc=vw/(1-e);
vlc=e*vc;
vf=1-vlc;
Vt/A=Pd/(r*v1*l);
v=vc/vf;
L=((2*1*P*v*t)/(r*v1))^0.5;
(1.025 * 1e6*(Lact)^2) + (900 - 2.050 * 1e6*(Lact)^2) = 0;
T=L*2;
Tact=Lact*2;

end Ex7_2;
//===============
