//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-7: Liquid Filtration
//Example: 7.3 Page 404
//Title:  Time and pressure across a filter
//======================================================
  
model Ex7_3
extends Modelica.Constants;

//=============
// Parameter Section

parameter Real H(unit="m")=760 " Height of liquid for pump";
parameter Real h[2](each unit="m")={360,600} " Height of liquid for sample";
parameter Real Q(unit="m^3/s")=0.00015 " Constant rate of water";
parameter Real t[2](each unit="s")={625,1105} " Time";
parameter Real p1(unit="kg/m^3") =1000 " Density";

//=============
// Variable Section

Real V[2](each unit="m^3") " Volume collected";
Real dP[2](each unit="kPa") " Pressure drops for sample";
Real LAv " Constant LAv";
Real Aruv " Constant A^2/ruv";
Real dP1 (unit="kPa") " Pressure drop for pump";
Real t1(unit="s") " Time to collect the volume";
Real P(unit="kPa") " Pressure at time t1";
//=============
// Equation Section

equation

V[1]=Q*t[1];
V[2]=Q*t[2];
dP[1]=g_n*p1*h[1]/1e3;
dP[2]=g_n*p1*h[2]/1e3;
dP1=g_n*p1*H/1e3;
V[1]^2+ (LAv*V[1]) = Aruv*dP[1]*t[1];
V[2]^2+ (LAv*V[2]) = Aruv*dP[2]*t[2];
// Integrating dV/dt=A^2(dP)/(ruv(V+LA/v))
t1=857;
1 + LAv*10*(1) = Aruv*100*t1*P;

end Ex7_3;
//===============
