//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-9: Centrifugal Separations
//Example: 9.3 Page 488
//Title:   Time taken to produce filtrate
//======================================================

model Ex9_3
extends Modelica.Constants;
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real l(unit="m")=25e-3 " Thickness";
parameter Real L(unit="m")=3e-3 " Resistance of cake";
parameter Real th(unit="m")=50e-3 " Thickness of frames";
parameter Real P(unit="Pa")=350e3 " Pressure Drop";
parameter Real t(unit="s")=3600 " Time";
parameter Real R(unit="m")=0.15 " Radius of centrifuge";
parameter Real ro(unit="m")=75e-3 " Radius of inner surface of slurry";
parameter Real H(unit="m")=0.2 " Height of centrifuge";
parameter Real f(unit="Hz")=65 " Frequency";
parameter Real p1(unit="kg/m^3")=1e3 " Density";

//=============
// Variable Section

Real rv " Value of ru/v";
Real Vc(unit="m^3") " Volume of cake";
Real r1 (unit="m") " Value of r' ";
Real w(unit="rad/s") " Angular frequency";
Real tc(unit="s") " Time required";

//=============
// Equation Section

equation

//In the filter press
// Vˆ2 + 2(AL/v)V = 2(delP )Aˆ2∗ t /( rv )

l^2+(2*L*l)=2*P*t/rv;
Vc=2*th*R^2;
pi*((R^2)-(r1^2))*H=Vc;
w=2*pi*f;
(((R^2)-(r1^2))*(1+2*(L/R)))+(2*(r1^2)*log(r1/R))=((2*tc*p1*w^2)/rv)*((R^2)-(ro^2));

end Ex9_3;
//===============
