model Ex10_2
  // rxn: 4NH3 + 5O2 --> 4NO + 6H2O
  //a - NH3, b - O2, c - NO, d - H2O
  Real Hrxn(unit = "kJ") "Heat of rxn", Hrxnpa(unit = "kj/gmol of NH3") "Heat of rxn per gmol of NH3";
  parameter Real Hfa(unit = "kJ/gmol of NH3") = -46.191 "Heat of formation of NH3", Hfb(unit = "kJ/gmol of O2") = 0 "Heat of formation of O2", Hfc(unit = "kJ/gmol of NO") = 90.374 "Heat of formation of NO", Hfd(unit = "kJ/gmol of H2O") = -241.826 "Heat of formation of H2O";
equation
  Hrxn = 4 * Hfc + 6 * Hfd - 4 * Hfa - 5 * Hfb;
  Hrxnpa = Hrxn / 4;
end Ex10_2;
