model Ex10_8
  // rxn: 3 glucose + 7.81 O2 --> 5.35 BM + 2.22 CA + 4.5 CO2
  //BM - Biomass, CA - citric acid
  // 1 - glucose, 2 - O2, 3 - BM, 4 - CA, 5 - CO2
  Real ni[5](each unit = "kg mol"), no[5](each unit = "kg mol"), W(unit = "kJ") "work done by pump", Q(unit = "kJ") "Heat removed", delH(unit = "kJ") "Heat of reaction";
  parameter Real m4(unit = "kg") = 10000 "mass of CA produced", mw4 = 192.12 "molecular weight of CA", mw1 = 180.16 "molecular weight of Flucose", xG = 0.6 "conversion of glucose", p(unit = "hp") = 100 "powe of pump", t(unit = "hr") = 220 "Time required for reaction", Hfi[5](each unit = "kJ/gmol") = {-1266, 0, -91.4, -1544.8, -393.51} "Reactant heat of formation", Hfo[5](each unit = "kJ /gmol") = {-1266, 0, -91.4, -1544.8, -393.51} "product heat of formation";
equation
  no[4] = m4 / mw4;
  ni[1] = no[4] * (3 / 2.22) * (1 / xG);
  ni[2] = no[4] * (7.81 / 2.22);
  no[2] = 0;
  no[1] = ni[1] * (1 - xG);
  ni[3] = 0;
  no[3] = no[4] * (5.35 / 2.22);
  ni[4] = 0;
  ni[5] = 0;
  no[5] = no[4] * (4.5 / 2.22);
// for closed system delU = Q + W
// delU = delH + del(pv) here pv is negligible hence delU = delH
  W = p * 754.7 * t * 3600 / 1000;
  delH = (sum(no .* Hfo) - sum(ni .* Hfi)) * 1000;
  Q = delH - W;
end Ex10_8;
