package Ex13_1
  model a
    Real mW(unit = "lb") "mass of water", nW(unit = "lb mol") "moles of water", mA(unit = "lb") "mass of ammonia";
    parameter Real pA = 3 "percentage of ammonia", mwA = 17 "molecular weight of ammonia", mwW = 18 "molecular weight of water", nA(unit = "lbmol") = 1 "moles of ammonia";
  equation
    mA = nA * mwA;
    pA / 100 = mA / (mA + mW);
    nW = mW / mwW;
//find amt of cooling needed from chart using nW
  end a;

  model b
    Real NA(unit = "lb mol") "lb moles of ammonia", MA(unit = "lb") "mass of ammonia", mW(unit = "lb") "mass of water per lbmol of ammonia", Q(unit = "Btu/ 100 gal sol") "Cooling required";
    parameter Real denW(unit = "lb/ft^3") = 62.4 "density of water", sgW = 1.003 "specific gravity of water", sgA = 0.889 "percentage of water", pA = 32 "percentage of ammonia", Hs(unit = "Btu/lb mol of NH3") = -13700 "Heat of solution", V(unit = "gal") = 100 "volume of solution", mwA = 17 "molecular weight of ammonia";
  equation
    MA = sgA * denW * sgW * V / 7.48;
    NA = MA * (pA / 100) / mwA;
    pA / 100 = mwA / (mwA + mW);
    Q = NA * Hs;
  end b;
end Ex13_1;
