model Ex13_2
  Real Q(unit = "J") "heat removed", nW "no of kmoles of water", nHCl "no of kmoles of HCl";
  parameter Real mW(unit = "kg") = 75 "mass of water", mHCl(unit = "kg") = 25 "mass of HCl", mwW = 18.02 "molecular weight of water", mwHCl = 36.37 "molecular weight of HCl", Hfo(unit = "J/gmol of HCl") = -157753 "product heat of formation", Hso(unit = "J/gmol") = 27 "product sensible heat", Hfi(unit = "J/gmol of HCl") = -92311 "reactant heat of formation", Hsi(unit = "J/gmol") = 2758 "reactant sensible heat";
equation
  nW = mW / mwW;
  nHCl = mHCl / mwHCl;
  Q = nHCl * Hfo + (nW + nHCl) * Hso - (nHCl * Hfi + nHCl * Hsi);
end Ex13_2;
