model Ex14_1
  Real W(unit = "J") "work", V2(unit = "m^3") "vapor volume";
  parameter Real P(unit = "Pa") = 100 * 10 ^ 3 "Pressure", V1(unit = "m^3") = 10 ^ (-3) "volume of water", sv(unit = "m^3 vapor / kg") = 1.694 "specific volume of vapor", den(unit = "kg / m^3 of liquid") = 1 / 0.001043 "density of liquid";
equation
  V2 = V1 * den * sv;
  W = -P * (V2 - V1);
end Ex14_1;
