model Ex14_3
  Real m(unit = "kg/s") "mass flow rate of water", dPE(unit = "W") "rate of Change in potential energy", eff "efficiency";
  parameter Real v(unit = "m^3/s") = 100 "volumetric flow rate", den(unit = "kg/m^3") = 1000 "density of water", E(unit = "W") = 20 * 10 ^ 6 "energy produced", h(unit = "m") = 25 "Height";
  constant Real g = 9.807;
equation
  m = v * den;
  dPE = m * g * h;
  eff = E / dPE;
end Ex14_3;
