package Ex14_5
  model a
    Real V2(unit = "ft^3") "final volume", W(unit = "Btu") "work";
    parameter Real P1(unit = "atm") = 1 "initial pressure", P2(unit = "atm") = 10 "final pressure", V1(unit = "ft^3") = 5 "final volume", m = 1.4;
  equation
    V2 = V1 * (P1 / P2) ^ (1 / m);
    W = -(P2 * V2 - P1 * V1) * 1.987 / (0.7302 * (1 - m));
  end a;

  model b
    Real n1(unit = "lb mol") "no of moles", W(unit = "Btu") "work";
    parameter Real P1(unit = "atm") = 1 "initial pressure", P2(unit = "atm") = 10 "final pressure", V1(unit = "ft^3") = 5 "final volume", m = 1.4, T(unit = "R") = 560;
    constant Real R(unit = "lbmol.R/ft^3.atm") = 0.7302;
  equation
    n1 = P1 * V1 / (R * T);
    W = V1 * P1 ^ 0.714 * (3.5 * (P2 ^ 0.286 - P1 ^ 0.286)) * (1.987 / 0.7302);
  end b;
end Ex14_5;
