model Ex14_6
  Real Whp(unit = "hp")"work required for pump", W(unit = "Btu/lbm"), Ev(unit = "Btu/lbm"), Wm(unit = "Btu/lbm"), PE(unit = "Btu/lbm");
  parameter Real m(unit = "lb") = 1 "mass of water pumped", h(unit = "ft") = 10 "height", P1(unit = "psi") = 100, P2(unit = "psi") = 1000, v(unit = "ft^3/lbm") = 0.0161 "specific volume";
  constant Real g(unit = "ft/s^2") = 32.2 "gravitational acceleration";
equation
  PE = m * g * h / (32.2 * 778);
  Wm = v * (P2 - P1) * 12 ^ 2 / 778;
  Ev = 320 / 778;
  W = PE + Wm + Ev;
  Whp = W * 1.415 / (0.6 * 60);
end Ex14_6;
