model Ex17_5
  //run upto 40 hr we will get both answers
  Real T(start = 60, unit = "F"), acc(unit = "Btu"), inp(unit = "Btu"), outp(unit = "Btu"), W(unit = "Btu/hr");
  parameter Real Cpo(unit = "Btu/lb.F") = 0.5 "specific heat of oil", eff = 0.75 "efficiency of motor", p(unit = "hp") = 1 "power of motor", mi(unit = "lb/hr") = 1018 "mass flow rate of input steam", mo(unit = "lb/hr") = 1018 "mass flow rater of output stream", mt(unit = "lb") = 5000 "mass of tank", hs(unit = "Btu/lb.F") = 291, Tin(unit = "F") = 60 "input stream temperature", Tref(unit = "F") = 60 "reference temperature", Ts(unit = "F") = 267 "surrouding temperature";
equation
  inp = mi * Cpo * (Tin - Tref) + hs * (Ts - T);
  outp = mo * Cpo * (T - Tref);
  acc = mt * Cpo * der(T);
  W = p * eff * 0.7608 * 3600;
  acc = inp - outp + W;
//Value of W in book is wrong
end Ex17_5;
