model Ex2_14
  Real mfCe "mass fraction of Ce", mfO "mass fraction of O", xCe "mole fractio of Ce", xO "mole fraction of O";
  parameter Real nCe = 1 "no of moles of Ce", nO = 1 "no. of moles of O";
  constant Real MWCe = 140.12 "molecular weight of Ce", MWO = 16 "molecular weight of O";
equation
  xCe = nCe / (nCe + nO);
  xO = nO / (nCe + nO);
  mfCe = MWCe * nCe / (MWCe * nCe + MWO * nO);
  mfO = MWO * nO / (MWCe * nCe + MWO * nO);
end Ex2_14;