model Ex2_15
  Real MW(unit = "kg/kgmol") "average molecular weight";
  parameter Real xH2 = 10 "percentage of H2", xCH4 = 40 "percentage of CH4", xCO = 30 "percentage of CO", xCO2 = 20 "percentage of CO2";
  constant Real mH2 = 2.02 "molecular weight of H2", mCH4 = 16.04 "molecular weight of CH4", mCO = 28 "molecular weight of CO", mCO2 = 44 "molecular weight of CO2";
equation
  MW = (xH2 * mH2 + xCH4 * mCH4 + xCO * mCO + xCO2 * mCO2) / 100;
end Ex2_15;