model Ex2_18
  Real Cd(unit = "kg/L") "concentration of drug", f(unit = "kgmol/min") "flowrate of drug", dS(unit = "gm soln/cm^3 of soln") "density of Solution";
  parameter Real fv(unit = "L/min") = 10.5 "flowrate of solution", xd = 0.412 "mass fraction of drug", SpGr = 1.024 "specific gravity of soution";
  constant Real dW(unit = "g/cm^3") = 1 "density of water", MWd = 192 "molecular weight of drug";
equation
  dS = SpGr * dW;
  Cd = xd * dS;
  f = Cd * fv/ MWd;
end Ex2_18;
