model Ex2_20
  Real mf(unit = "mg of HCN/kg of air"), ldf "lethal dose fraction";
  parameter Real ld(unit = "mg/kg of air") = 300 "lethal dose", C(unit = "ppm") = 10 "concentration of HCN";
  constant Real mHCN = 27.03 "molecular weight of HCN", mAir = 29 "molecular weight of Air";
equation
  mf = C / 10 ^ 6 * (mHCN / mAir) * 10 ^ 6;
// 10^6 with C is for converting to gmol and 10^6 at end is for converting units of weights of HCN and Air
  ldf = mf / ld;
end Ex2_20;