model Ex4_1
  Real B(unit = "L/hr") "flow rate of solution after extraction", P(unit = "L/hr") "flow rate of organic solvent after extraction", cP(unit = "gm strep/L") "Conc of strep in P", dP(unit = "g/cm^3") "density of P", mfP "mass fration of steptomycin in P";
  parameter Real A(unit = "L/hr") = 200 "Flow rate of solution before extractioin", S(unit = "L/hr") = 10 "Flow rate of organic solvent before extraction", cA(unit = "gm strep/L") = 10 "Conc of strep in A", cB(unit = "gm strep/L") = 0.2 "Conc of strep in B", cS(unit = "gm strep/L") = 0 "Conc of strep in S", dA(unit = "g/cm^3") = 1 "density of A", dS(unit = "g/cm^3") = 0.6 "density of S";
equation
  A = B;
//water balance
  S = P;
//solution balance
  cA * A + cS * S = cB * B + cP * P;
//streptomycin balance
  dS = dP;
  mfP = cP / (1000 * dP) / (1 + cP / (1000 * dP));
//1000 is for L to cm^3 conversion
end Ex4_1;