model Ex4_2
  Real P(unit = "mol") "Product stream", W(unit = "mol") "waste stream", xWO2 "Oxygen fraction in waste stream", xWN2 "Nitrogen fraction in waste stream";
  parameter Real F(unit = "mol") = 100, xFO2 = 0.21"Oxygen fraction in Feed stream", xFN2 = 0.79"Nitrogen fraction in feed stream", xPO2 = 0.25"Oxygen fraction in Product stream", xPN2 = 0.75"Nitrogen fraction in Product stream", m = 0.8;
equation
  F = W + P;
  xFO2 * F = xWO2 * W + xPO2 * P;
  xFN2 * F = xWN2 * W + xPN2 * P;
  m = W / F;
end Ex4_2;
