model Ex4_3
  Real B(unit = "kg") "Bottoms", xBWat "water fraction in bottom", xBEt "Ethanol fraction in bottom", D(unit = "kg") "Distillate", EtL "mass fraction of Ethanol lost";
  parameter Real F(unit = "kg") = 1000"Feed", xFEt = 0.1"Ethanol fraction in Feed", xFWat = 0.9"Water fraction in Feed", xDEt = 0.6"Ethanol fraction in Distillate", xDWat = 0.4"Water fraction in Distillate", m = 0.1;
equation
  F = D + B;
  xFWat * F = xDWat * D + xBWat * B;
  xFEt * F = xDEt * D + xBEt * B;
  m = D / F;
  EtL = xBEt * B / (xFEt * F);
end Ex4_3;
