model Ex5_12
  Real ex "excess air", reqO2 "required O2", O2avail "O2 available";
  parameter Real mpro(unit = "kg") = 20 "mass of propane", mair(unit = "kg") = 400 "mass of air", xO2 = 0.21 "O2 fraction in air", mwAir = 29"Molecular weight of Air", mwPro = 44.09"Molecular weight of Propane";
equation
  reqO2 = mpro / mwPro * 5;
  O2avail = mair / mwAir * xO2;
  ex = 100 * (O2avail - reqO2) / reqO2;
end Ex5_12;
