model Ex5_13
  // Let A - CH4, B - Air, C - N2, D - O2, E - CO2, F - H2O
  //m - mass, mw - molecular weight
  Real nA "moles of CH4 in", nB "moles of air in", nC1 "moles of N2 in", nC2 "moles of N2 out", nD1 "moles of O2 in", nD2 "moles of O2 out", nE "moles of CO2 out", nF "moles of H2O out";
  parameter Real mA(unit = "kg") = 16, mB(unit = "kg") = 300, mwA = 16, mwB = 29, xO2 = 0.21, xN2 = 0.79;
equation
  nA = mA / mwA;
  nB = mB / mwB;
  nC1 = nB * xN2;
  nC2 = nC1;
  nD1 = nB * xO2;
  nE = nA;
  nF = 2 * nA;
  2 * nD1 = 2 * nD2 + 2 * nE + nF;
end Ex5_13;
