model Ex5_5
  Real xCO2 "xmax based on CO2", xH "xmax based on H", mCH2O;
  parameter Real mCO2(unit = "g") = 1.81 "initial mass of CO2", mH(unit = "g") = 0.057 "initial mass of H", mwCO2 = 44 "molecular weight of CO2", mwH = 1 "molecular weight of H", mwCH2O = 30.02 "molecular weight of CH2O";
equation
  xCO2 = (0 - mCO2 / mwCO2) / (-1);
//assuming complete conversion of CO2, 1 is soichiometric coeff.
  xH = (0 - mH / mwH) / (-4);
//assuming complete conversion of H, 4 is stoichiometric coeff.
  mCH2O = xH / 4 * mwCH2O;
//calculation mistake in book for mCH2O
end Ex5_5;
