model Ex5_7
  // let A - CH4, B - Cl2, C - CH3Cl, D - HCl, E - N2
  //f is for final , i is for initial, x is conversion and xA, xB is max conversion if limiting reactant is A and B respectively
  Real nAf, nBf, nCf, nDf, nEf, xR, xA, xB;
  parameter Real nAi = 40, nBi = 50, nEi = 10, nCi = 0, nDi = 0, x = 0.67;
equation
  xA = nAi / 1;
  xB = nBi / 1;
  xR = x * min(xA, xB);
  nAf = nAi - xR;
  nBf = nBi - xR;
  nCf = nCi + xR;
  nDf = nDi + xR;
  nEf = nEi;
end Ex5_7;
