model Ex6_3
// x are mole fractions
// A, A1, G, W, F are molar flow rates of respective streams
  Real A(unit = "lbmol / hr"), A1(unit = "lbmol / hr"), G(unit = "lbmol / hr"), W(unit = "lbmol / hr"), F(unit = "lbmol / hr"), r(unit = "bbl/hr") "combustion rate of fuel oil", t(unit = "hr") "time for which fuel will last";
  parameter Real P(unit = "lbmol / hr") = 6205, xG[3] = {0.96, 0.02, 0.02} "CH4, C2H2, CO2", xF[3] = {0.5, 0.47, 0.03} "C, H2, S", xA[2] = {0.21, 0.79} "O2, N2", xA1[3] = {0.2, 0.76, 0.04} "O2, N2, CO2", xP[4] = {0.8493, 0.0413, 0.001, 0.1084} "N2, O2, SO2, CO2", xW = 1 "water fraction", reserve(unit = "bbl") = 560 "fuel oil reserve";
equation
  (4 * xG[1] + 2 * xG[2]) * G + 2 * xF[2] * F = 2 * xW * W;
//H balance
  (xG[1] + 2 * xG[2] + xG[3]) * G + xF[1] * F + xA1[3] * A1 = xP[4] * P;
// C balance
  2 * xG[3] * G + 2 * xA[1] * A + (2 * xA1[1] + 2 * xA1[3]) * A1 = (2 * xP[2] + 2 * xP[3] + 2 * xP[4]) * P + xW * W;
//O balance
  xF[3] * F = xP[3] * P;
//S balance
  2 * xA[2] * A + 2 * xA1[2] * A1 = 2 * xP[1] * P;
  r = F * (7.91 / (7.578 * 42));
  t = reserve / r;
end Ex6_3;
