model Ex6_4
// F, D, E, G, H, K, L, M are mass flow rates of respective streams
// x is mass fraction
//s - sugar, p - Pulp, w - water
  Real F(unit = "lb/hr"), D(unit = "lb/hr"), E(unit = "lb/hr"), G(unit = "lb/hr"), H(unit = "lb/hr"), J(unit = "lb/hr"), K(unit = "lb/hr"), L(unit = "lb/hr"), xDw, xDs, xEw, xGs, xGw, xHs, xHw, xKw, psr "percentage sugar recovered";
  parameter Real M = 1000, xFs = 0.16, xFw = 0.25, xFp = 0.59, xDp = 0.8, xEs = 0.13, xEp = 0.14, xGp = 0.95, xJw = 1, xLw = 1, xMs = 1, xKs = 0.4;
equation
  F = 24574;
//assumed because system becoming under determined
  xEs + xEw + xEp = 1;
  xDs + xDw + xDp = 1;
  xGs + xGw + xGp = 1;
  xHs + xHw = 1;
  xKs + xKw = 1;
  F * xFs = D * xDs + E * xEs;
  F * xFw = D * xDw + E * xEw;
  F * xFp = D * xDp + E * xEp;
  E * xEs = G * xGs + H * xHs;
  E * xEw = G * xGw + H * xHw;
  E * xEp = G * xGp;
  H * xHs = K * xKs;
  H * xHw = K * xKw + J * xJw;
  K * xKs = M * xMs;
  K * xKw = L * xLw;
  psr = M / (F * xFs);
end Ex6_4;
