model Ex6_6
  Real F(unit = "mol")"Moles of fresh feed", FH2(unit = "mol")"Moles of H2 in feed", PBz(unit = "mol")"Moles of Benzene in Product", PH2(unit = "mol")"Moles of Hydrogen in Product", PCx(unit = "mol"), RBz(unit = "mol")"Moles of Benzene in recycle", RH2(unit = "mol")"Moles of H2 in recycle", P(unit = "mol")"Product moles", R(unit = "mol")"Recycle Moles", r;
  parameter Real FBz(unit = "mol") = 100, x = 0.95 "overall conversion", xpp = 0.2 "reactor per pass conversion", xRBz = 0.2274 "fractiono Benzene in R", xRH2 = 0.7726 "fraction of H2 in R";
equation
  FH2 = FBz * 3 * (1 + 0.2);
  F = FH2 + FBz;
  PBz = FBz * (1 + (-1) * x);
  PH2 = FH2 + FBz * (-3) * x;
  PCx = FBz * x;
  P = PBz + PH2 + PCx;
  PCx = xpp * (FBz + RBz);
  RBz = xRBz * R;
  RH2 = xRH2 * R;
  r = R / F;
end Ex6_6;
