model Ex6_7
// T, R , P, F are masses of respective streams
// x is mass fraction
// W - Water, G - Glucose, F - Fructose
  Real T(unit = "kg"), R(unit = "kg"), P(unit = "kg"), xRG, xRW, xRF, xTG, xTW, x "per pass conversion";
  parameter Real F(unit = "kg") = 100, xFG = 0.4, xFW = 0.6, xTF = 0.04, r = 8.33;
equation
  F = P;
  P / R = r;
  F + R = T;
  xFW * F + xRW * R = xTW * T;
  xRF * R = xTF * T;
  xTG * T - xRG * T = x * xTG * T;
  xTG + xTW + xTF = 1;
  xRG + xRW + xRF = 1;
  xFW * F = xRW * P;
end Ex6_7;
