model Ex6_8
// S, P, x, y, F are masses of of respective streams
// prefix x are fractions
// ip - i pentane, np - n pentane
  Real S(unit = "kg"), P(unit = "kg"), x(unit = "kg"), y(unit = "kg"), frac;
  parameter Real F(unit = "kg") = 100, xFnp = 0.8, xFip = 0.2, xSip = 1, xPnp = 0.9, xPip = 0.1;
equation
  F = S + P;
  F * xFnp = P * xPnp;
  x = S + y;
  x * xFip = S * xSip;
  frac = x / F;
end Ex6_8;
