model Ex7_4
  // A - CO2 , B - O2, C - CO, D - H2, E - CH4, F - N2, G - H2O
  Real nAo "moles of A out", nBo "moles of B out", nCo "moles of C out", nFo "moles of F out", nGo "moles of G out", nBa "moles of B in air", nFa "moles fo F in air", Vg(unit = "ft^3") "volume of gas", Va(unit = "ft^3") "volume of air", Vp(unit = "ft^3") "volume of product", r1 "ratio of Va to Vg", r2 "ratio of Vp to Vg";
  parameter Real F = 100 "no of moles in feed", nAf = 6.4 "no of A moles in feed", nBf = 0.1 "no of B moles in feed", nCf = 39 "no of C moles in feed", nDf = 51.8 "no of D moles in feed", nEf = 0.6 "no of E moles in feed", nFf = 2.1 "no of F moles in feed", xBa = 0.21 "fraction of B moles in air", xFa = 0.79 "fraction of F moles in air", Ts(unit = "R") = 492 "standard temperature", Tg(unit = "R") = 550 "temperature of gas", Ta(unit = "R") = 530 "air temperature", Tp(unit = "R") = 860 "product temperature", Vs(unit = "ft^3") = 359 "standard volume", Ps(unit = "mm Hg") = 29.92 "standard pressure", Pg(unit = "mm Hg") = 35 "Gas pressure", Pa(unit = "mm Hg") = 29.4 "Air pressure", Pp(unit = "mm Hg") = 35 "product pressure";
equation
  nBa = (0.5 * nCf + 0.5 * nDf + 2 * nEf) * (1 + 0.4);
  nFa = nBa * (xFa / xBa);
  2 * nFf + 2 * nFa = 2 * nFo;
  nAf + nCf + nEf = nAo + nCo;
  2 * nDf + 4 * nEf = 2 * nGo;
  2 * nAf + 2 * nBf + nCf + 2 * nBa = 2 * nAo + 2 * nBo + nCo + nGo;
  nCo = 0.1 * nCf;
  Vg = F * Vs * (Tg / Ts) * (Ps / Pg);
  Va = (nBa + nFa) * Vs * (Ta / Ts) * (Ps / Pa);
  Vp = (nAo + nBo + nCo + nFo + nGo) * Vs * (Tp / 429) * (Ps / Pp);
  r1 = Va / Vg;
  r2 = Vp / Vg;
end Ex7_4;
