model Ex7_5
  Real F(unit = "m3/min") "flow rate of F", P(unit = "m3/min") "flowrate of P", V2(unit = "m3/min") "flowrate of CO2 at Pg and Tg";
  parameter Real xFCO2 = 0.012 "fraction of CO2 in F", xFo = 0.988 "fraction of others in F", xPCO2 = 0.034 "fraction of CO2 in P", xPo = 0.966 "fraction of others in P", xVCO2 = 1 "faction of CO2 in V1 and V2", V1(unit = "m3/min") = 0.0917 "flow rate of CO2 at Pv and Tv", Tg(unit = "C") = 15 "Temperature of gas", Tv(unit = "C") = 7 "Temperature of CO2 stream", Pg(unit = "kPa") = 105 "Pressure of Gas", Pv(unit = "kPa") = 131 "Pressure of CO2";
equation
  V2 = V1 * (Pv / Pg) * ((Tg + 273) / (Tv + 273));
  F * xFo = P * xPo;
  F * xFCO2 + V2 * xVCO2 = P * xPCO2;
end Ex7_5;
