model Ex7_6
  Real a "RK constant", b "RK  constant", P(unit = "atm") "Pressure";
  parameter Real Pc(unit = "atm") = 50.44 "Critical Pressure", Tc(unit = "K") = 282.8 "Critical Temperature", V(unit = "L / fmol") = 0.674 "molar volume", T(unit = "K") = 300 "Volume";
  constant Real R(unit = "L*atm/gmol/K") = 0.08206;
equation
  a = 0.42748 * (R ^ 2 * Tc ^ 2.5) / Pc;
  b = 0.08664 * (R * Tc) / Pc;
  P = R * T / (V - b) - a / (T ^ 0.5 * V * (V + b));
end Ex7_6;
