model Ex7_7
  Real Vi(unit = "ft^3/lb") "Molar volume by idea gas law", Vr(unit = "ft^3/lb") "Real molar Volume of Ammonia", n "no. of moles o f ammonnia", mt(unit = "lb") "mass of ammonia in tank";
  parameter Real R(unit = "psia*ft^3/lbmol/R") = 10.73, P(unit = "psia") = 306.7 "Pressure", T(unit = "R") = 585 "Temperature", m(unit = "lb") = 1 " Basis", mw = 17 "molecular weight of ammonia", z = 0.855 "compressibility factor", Vt(unit = "ft^3") = 120 "Volume of Tank";
equation
  n = m / mw;
  Vi = n * R * T / P;
  Vr = z * n * R * T / P;
  mt = m * Vt / Vr;
end Ex7_7;
