model Ex8_2
  Real vp(unit = "mm Hg") "vapor pressure of Al", vpk(unit = "kPa") "vapor pressure of Al", m(unit = "g / (cm^2 *s)") "rate of evaporation";
  parameter Real A = 8.779 "antoine constant", B = 1.615e4 "antoine constant", C = 0 "antoine constant", T(unit = "C") = 972 "Temperature", mw = 26.98 "molecular weight of Al";
equation
  log(vp) = A - B / (T + 273 + C);
  vpk = vp * 0.1333;
  m = 0.437 * (vpk * mw ^ 0.5 / (T + 273) ^ 0.5);
end Ex8_2;
