model Ex8_7
  //case 1 - Coal,case 2 - natural gas
  Real nH2 "H2 moles in 1", nO2_1 "O2 moles in 1", nN2_1 "N2 moles in 1", nCO2_1 "CO2 produced by 1", nH2O_1 "H2O produced by 1", nO2_2 "O2 moles in 2", nN2_2 "N2 moles in 2", nCO2_2 "CO2 produced in 2", nH2O_2 "H2O produced in 2", pH2O_1(unit = "kPa") "partial pressure of H2O in 1", pH2O_2(unit = "kPa") "partial pressure of H2O in 2", eO2_1 "excess O2 in 1", eO2_2 "excess O2 in 2";
  parameter Real nC = 1 "C moles n 1", m = 0.47 "ratio of C to H in 1", nCH4 = 1 "CH4 moles in 2", xN2 = 0.79 "fraction of Nitrogen in air", xO2 = 0.21 "fraction of Oxygen in air", P(unit = "kPa") = 100 "Total pressure";
equation
  nH2 = nC * m;
  nO2_1 = (nC + nH2 * 0.5) * (1 + 0.4);
  nN2_1 = nO2_1 * (xN2 / xO2);
  nCO2_1 = nC;
  nH2O_1 = nH2;
  eO2_1 = nO2_1 - (nCO2_1 + 0.5 * nH2O_1);
  nO2_2 = 2 * nCH4 * (1 + 0.4);
  nN2_2 = nO2_2 * (xN2 / xO2);
  nCO2_2 = nCH4;
  nH2O_2 = 2 * nCH4;
  eO2_2 = nO2_2 - (nCO2_2 + 0.5 * nH2O_2);
  pH2O_1 = P * (nH2O_1 / (nCO2_1 + nH2O_1 + eO2_1 + nN2_1));
  pH2O_2 = P * (nH2O_2 / (nCO2_2 + nH2O_2 + eO2_2 + nN2_2));
end Ex8_7;
