model Ex8_8
  Real Vair(unit = "m^3") "volume of air", pair(unit = "kPa") "partial pressure of dry air", nair "no of moles of air", nea "ethyl alcohol moles";
  parameter Real T(unit = "K") = 293 "Temperature", P(unit = "kPa") = 100 "Pressure", mw = 46.07 "molecular weight of ethyl alcohol", pea(unit = "kPa") = 5.93 "partial pressure of ethyl alcohol", m(unit = "kg") = 6 "mass of ethyl alcohol";
  constant Real R(unit = "kpa*m^3/kgmol/K") = 8.314;
equation
  nea = m / mw;
  pair = P - pea;
  nair = nea * (pair / pea);
  Vair = nair * R * T / P;
end Ex8_8;
