model Ex9_12
  Real n(unit = "gmol") "no of moles", Cp(unit = "J/gmol.K") "sp. heat capacity of gas", Cv(unit = "J/gmol.K") "sp heat capacity of gas", delUg(unit = "J") "internal energy change of gas", delUh(unit = "J") "internal energy change of heater", T2(unit = "K") "final temperature", P2(unit = "Pa") "final pressure";
  parameter Real P1(unit = "Pa") = 1.5 "initial pressure", V(unit = "m^3") = 10 ^ (-3) "volume", T1(unit = "K") = 300 "initial temperature", delU(unit = "J") = 480 "internal energy change of system", m(unit = "kg") = 12 "mass of heater", Ch(unit = "J/g.K") = 0.35 "sp heat capacity of heater";
  constant Real R(unit = "gmol.K/Pa/m^3") = 8.314 "gas constant";
equation
  n = P1 * V / (R * T1);
  Cp = 5 / 2 * R;
  Cv = Cp - R;
  delUg = n * Cv * (T2 - T1);
  delUh = m * Ch * (T2 - T1);
  delU = delUg + delUh;
  P1 * T2 = P2 * T1;
end Ex9_12;
