model Ex9_14
  //1-CO1, 2-N2, 3-CH4, 4-H2O
  Real mw(unit = "kg/min") "mass flow of water", delHg(unit = "kJ") "enthalpy of gas";
  parameter Real ng(unit = "kgmol/min") = 100 "moles of gas", n[4] = {20, 10, 30, 40}, delH[4](each unit = "kJ/kgmol") = {-9333, -6215, -11307, -7441}, delhw(unit = "kJ/kg") = 875.7 "sp. enthalpy of water";
equation
  delHg = sum(delH .* n);
  mw = -delHg / delhw;
end Ex9_14;
