model Ex9_15
  Real W(unit = "kW") "electric power", m(unit = "lbm water/s") "mass flow of water", h(unit = "ft") "Height";
  parameter Real v(unit = "ft^3/s") = 0.5 "volumetric flow rate of water", den(unit = "lbm/ft^3") = 62.4 "density of water", g(unit = "ft/s^2") = 32.2 "gravitational acceleration", ha(unit = "ft") = 5 "height above well", hb(unit = "ft") = 20 "height below well";
equation
  m = v * den;
  h = ha + hb;
  W = m * g * h * (1.055 / (32.2 * 778.2));
end Ex9_15;
