model Ex9_2
  Real Wp(unit = "kJ") "constant pressure work done", Wt(unit = "kJ") "constant temperature work done", n "no of moles";
  parameter Real V1(unit = "m^3") = 0.1 "initial volume", V2(unit = "m^3") = 0.2 "final volume", P1(unit = "kPa") = 200 "initial pressure", T1(unit = "K") = 300 "initial temperature";
  constant Real R(unit = "kJ /kgmol/K") = 8.314;
equation
  P1 * V1 = n * R * T1;
  Wp = -P1 * (V2 - V1);
  Wt = -n * R * T1 * log(V2 / V1);
end Ex9_2;
