model Ex10_11
  Real HHV(unit = "kJ/kg") "Heating value of coal";
  parameter Real xC = 0.71 "percentage of carbon", xO2 = 0.13 "percentage of O2", xH2 = 0.056 "percentage of H2", xS = 0.027 "percentage of S";
equation
  HHV = (14544 * xC + 62028 * (xH2 - xO2 / 8) + 4050 * xS) * (1.055 / 0.454);
//(1.055 / 0.454) is for converting Btu/lb to kJ/kg
end Ex10_11;
