model Ex10_3
  //rxn a: CH3NH2 + COCl2 --> C2H3NO + 2HCl
  //rxn b: C2H3NO + C10H8O --> C12H11O2N
  //rxn c: C10H8O + COCl2 --> C11H7O2Cl
  //rxn d: C11H7O2Cl + CH3NH2 --> C12H11O2N + HCl
  //1: Carbaryl, 2:Hydrogen Chloride, 3:Methyl amine, 4:Methyl isocyanate, 5: 1-Napthalenyl chloroformate, 6: 1-Napthol, 7: Phosgene
  //Hrxn: heat of reaction, Hf: heat of formation
  Real Hrxna, Hrxnb, Hrxnc, Hrxnd;
  parameter Real Hf1 = -26, Hf2 = -92.311, Hf3 = -20, Hf4 = -9 * 10 ^ 4, Hf5 = -17.9, Hf6 = 30.9, Hf7 = -221.85;
equation
  Hrxna = 2 * Hf2 + Hf4 - (Hf3 + Hf7);
  Hrxnb = Hf1 - (Hf4 + Hf6);
  Hrxnc = Hf5 - (Hf6 + Hf7);
  Hrxnd = Hf1 + Hf2 - (Hf3 + Hf5);
end Ex10_3;
