model Ex10_4
  // rxn: CO2 + H2 --> H2O + CH4
  //1 - CO2, 2 - H2, 3 - H2O, 4 - CH4
  Real no[4](each unit = "gmol") "Product no of moles", eps "conversion of reacting species", Hrref(unit = "kJ/gmol CO2") "Heat of rxn at ref temp", Hr(unit = "kJ/gmol of CO2") "Heat of rxn";
  parameter Real ni[2](each unit = "gmol") = {1.5, 4}, x = 0.4 "conversion of CO2", Hsi[2](each unit = "kJ/gmol") = {30.975, 2.123} "sensible heat in", Hso[4](each unit = "kJ/gmol") = {20.996, 13.826, 17.010, 23.126} "sensible heat out", Hf[4](each unit = "kJ/gmol") = {-393.25, 0, -241.835, -74.848} "Heat of formation";
equation
  no[1] = ni[1] * (1 - x);
  no[2] = ni[2] - 4 * ni[1] * x;
  no[3] = 2 * ni[1] * x;
  no[4] = ni[1] * x;
  eps = (ni[2] - no[2]) / ni[2];
  Hrref = eps * (2 * Hf[3] + Hf[4] - Hf[1] - 4 * Hf[2]);
  Hr = Hrref - (Hsi[1] * ni[1] + Hsi[2] * ni[2]) + sum(Hso .* no);
end Ex10_4;
