model Ex10_5
  Real H(unit = "kJ") "Enthalpy change of rxn", Hi(unit = "kJ") "Enthalpy in", Ho(unit = "kJ") "Enthalpy out";
  parameter Real ni[2](each unit = "gmol") = {1.5, 4} "reactant moles", no[4](each unit = "gmol") = {0.9, 1.6, 1.2, 0.6} "product moles", Hfi[2](each unit = "kJ/gmol") = {-393.25, 0} "Heat of formation of reactant", Hfo[4](each unit = "kJ/gmol") = {-393.25, 0, -241.835, -74.848} "Heat of formation product", Hsi[2](each unit = "kJ/gmol") = {30.975, 2.123} "sensible heat of reactants", Hso[4](each unit = "kJ/gmol") = {20.996, 13.826, 17.010, 23.126} "sensible heat of product";
equation
  Hi = sum(ni .* Hfi) + sum(ni .* Hsi);
  Ho = sum(no .* Hfo) + sum(no .* Hso);
  H = Ho - Hi;
end Ex10_5;
