model Ex10_6
  // for in 1 - CH4, 2 - O2, 3 - N2, 4 - CaCO3
  // for out 1 - CaO, 2 - CO2, 3 - O2, 4 - N2, 5 - H2O
  // L, G, P, A etc are gmoles of respective stream
  Real L(unit = "gmol"), P(unit = "gmol"), G(unit = "gmol"), A(unit = "gmol"), ni[4](each unit = "gmol"), no[5](each unit = "gmol"), ans(unit = "lb of CaCO3/ ft^3 of CH4 at SC");
  parameter Real M(unit = "gmol") = 1, xO2 = 0.21 "fraction of O2 in air", xN2 = 0.79 "fraction of N2 in air", Hfi[4] = {-49.963, 0, 0, -1206.9} "Reactant heat of formation", Hsi[4] = {0, 0, 0, 0} "reactant sensible heat", Hfo[5] = {-635.6, -393.25, 0, 0, -241.835} "product heat of formation", Hso[5] = {54.25, 21.425, 15.034, 14.241, 17.010} "product sensible heat", V(unit = "ft^3") = 1000 "volume of CH4";
equation
  ni[1] = M;
  ni[2] = 2 * M * (1 + 0.5);
  ni[3] = ni[2] * xN2 / xO2;
  A = ni[2] + ni[3];
  ni[4] = L;
  no[1] = P;
  G = sum(no) - no[1];
  L = P;
  L + M = no[2];
  3 * L + 2 * ni[2] = P + 2 * no[2] + 2 * no[3] + no[5];
  4 * M = 2 * no[5];
  ni[3] = no[4];
  sum(ni .* Hsi) + sum(ni .* Hfi) = sum(no .* Hso) + sum(no .* Hfo);
  ans = V * (1 / 359.05) * L / M;
end Ex10_6;
