model Ex11_1
  Real pH2O(unit = "in Hg") "pressure of water vapor in air", m(unit = "lb H2O") "mass of water vapor";
  parameter Real rH(unit = "percent") = 43 "relative humidity", bP(unit = "in Hg") = 29.92 "barometric pressure", den(unit = "lbmol/ft^3") = 1 / 359 "molar density", mw = 18 "molecular weight of water", vp(unit = "in Hg") = 1.61 "Vapor pressure of water", V(unit = "mi^3") = 1 "Volume of air";
equation
  pH2O = vp * (rH / 100);
  m = V * 5280 ^ 3 * (492 / 555) * (pH2O / bP) * mw * den;
end Ex11_1;
