model Ex11_5
  Real DAo(unit = "lb")"dry air out", DAi(unit = "lb")"dry air in", Hwi(unit = "BTU/lb H2O")"Enthalpy of Water in", Hwo(unit = "BTU/lb H2O")"Enthalpy of Water out", W(unit = "lb")"Pounds of water entering tower", Wl, Wo;
  parameter Real vDAi(unit = "ft^3") = 8.3 * 10 ^ 6 "volume of moist air in", Vwi(unit = "dry air/ ft^3") = 13.82, Cpw(unit = "Btu/lb.F") = 1 "specific heat of water", Twi(unit = "F") = 120 "Water in temp", Two(unit = "F") = 90 "Water out temp", Hai = 29.93, Hao = 55.83, H1(unit = "lb H2O/lb dry air") = 0.0098, H2(unit = "lb H2O/lb dry air") = 0.0297;
equation
  DAi = vDAi / Vwi;
  Hwo = Cpw * (Two - 32);
  Hwi = Cpw * (Twi - 32);
  DAi = DAo;
  Wl = H2 - H1;
  Hai + Hwi * W = Hao + Hwo * (W - Wl);
  Wo = (W - Wl) * DAo;
end Ex11_5;
